<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>AI Asistan - Admin Panel</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .admin-nav {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        .stat-card {
            border-radius: 15px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            transition: transform 0.2s;
        }
        .stat-card:hover {
            transform: translateY(-5px);
        }
    </style>
</head>
<body class="bg-light">
    <nav class="navbar navbar-expand-lg navbar-dark admin-nav">
        <div class="container">
            <a class="navbar-brand" href="#">
                <i class="fas fa-robot me-2"></i>AI Asistan Admin
            </a>
            <ul class="navbar-nav ms-auto">
                <li class="nav-item">
                    <a class="nav-link" href="/"><i class="fas fa-home me-1"></i>Ana Sayfa</a>
                </li>
            </ul>
        </div>
    </nav>

    <div class="container mt-4">
        <div class="row">
            <div class="col-12">
                <h2><i class="fas fa-tachometer-alt me-2"></i>Sistem Durumu</h2>
                <p class="text-muted">AI asistan sistemi istatistikleri ve ayarları</p>
            </div>
        </div>

        <div class="row mb-4">
            <div class="col-md-3">
                <div class="card stat-card text-center p-3">
                    <i class="fas fa-phone fa-2x text-primary mb-2"></i>
                    <h4 id="totalCalls">0</h4>
                    <p class="text-muted mb-0">Toplam Arama</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card stat-card text-center p-3">
                    <i class="fas fa-clock fa-2x text-warning mb-2"></i>
                    <h4 id="activeCalls">0</h4>
                    <p class="text-muted mb-0">Aktif Aramalar</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card stat-card text-center p-3">
                    <i class="fas fa-check-circle fa-2x text-success mb-2"></i>
                    <h4 id="completedCalls">0</h4>
                    <p class="text-muted mb-0">Tamamlanan</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card stat-card text-center p-3">
                    <i class="fas fa-microphone fa-2x text-info mb-2"></i>
                    <h4 id="voiceStatus">Aktif</h4>
                    <p class="text-muted mb-0">Ses Durumu</p>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h5><i class="fas fa-cog me-2"></i>Sistem Ayarları</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label">Elevenlabs API Durumu</label>
                            <div id="apiStatus" class="alert alert-info">
                                <i class="fas fa-spinner fa-spin me-2"></i>Kontrol ediliyor...
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Aktif Ses</label>
                            <div id="currentVoice" class="form-control bg-light">Yükleniyor...</div>
                        </div>
                        <button id="testApiBtn" class="btn btn-primary">
                            <i class="fas fa-check me-2"></i>API Bağlantısını Test Et
                        </button>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h5><i class="fas fa-list me-2"></i>Son Aramalar</h5>
                    </div>
                    <div class="card-body">
                        <div id="recentCalls">
                            <div class="text-center text-muted p-3">
                                <i class="fas fa-phone fa-2x mb-2"></i>
                                <p>Henüz arama yapılmadı</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row mt-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h5><i class="fas fa-brain me-2"></i>Bilgi Bankası Yönetimi</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-8">
                                <textarea id="knowledgeContent" class="form-control" rows="5" 
                                    placeholder="Yeni bilgi bankası içeriği ekleyin..."></textarea>
                            </div>
                            <div class="col-md-4">
                                <button id="addKnowledgeBtn" class="btn btn-success w-100 mb-2">
                                    <i class="fas fa-plus me-2"></i>İçerik Ekle
                                </button>
                                <button id="listKnowledgeBtn" class="btn btn-info w-100">
                                    <i class="fas fa-list me-2"></i>Mevcut İçerikler
                                </button>
                            </div>
                        </div>
                        <div id="knowledgeList" class="mt-3"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Admin panel JavaScript functionality
        document.addEventListener('DOMContentLoaded', function() {
            loadSystemStatus();
            loadVoiceInfo();
            loadKnowledgeBase();
            
            // Event listeners
            document.getElementById('testApiBtn').addEventListener('click', testApiConnection);
            document.getElementById('addKnowledgeBtn').addEventListener('click', addKnowledge);
            document.getElementById('listKnowledgeBtn').addEventListener('click', loadKnowledgeBase);
        });

        async function loadSystemStatus() {
            try {
                const response = await fetch('/api/test');
                const data = await response.json();
                
                if (data.success) {
                    document.getElementById('apiStatus').innerHTML = 
                        '<i class="fas fa-check me-2"></i>API bağlantısı başarılı';
                    document.getElementById('apiStatus').className = 'alert alert-success';
                } else {
                    document.getElementById('apiStatus').innerHTML = 
                        '<i class="fas fa-times me-2"></i>API bağlantı hatası';
                    document.getElementById('apiStatus').className = 'alert alert-danger';
                }
            } catch (error) {
                document.getElementById('apiStatus').innerHTML = 
                    '<i class="fas fa-times me-2"></i>Bağlantı hatası: ' + error.message;
                document.getElementById('apiStatus').className = 'alert alert-danger';
            }
        }

        async function loadVoiceInfo() {
            try {
                const response = await fetch('/api/voices/current');
                const data = await response.json();
                
                if (data.voice) {
                    document.getElementById('currentVoice').textContent = 
                        data.voice.name + ' (' + data.voice.voice_id + ')';
                } else {
                    document.getElementById('currentVoice').textContent = 'Ses seçilmedi';
                }
            } catch (error) {
                document.getElementById('currentVoice').textContent = 'Bilgi alınamadı';
            }
        }

        async function testApiConnection() {
            const btn = document.getElementById('testApiBtn');
            const originalText = btn.innerHTML;
            
            btn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>Test ediliyor...';
            btn.disabled = true;
            
            try {
                const response = await fetch('/api/test');
                const data = await response.json();
                
                if (data.success) {
                    alert('✅ API bağlantısı başarılı!\n\nElevenlabs API ile bağlantı kuruldu.');
                } else {
                    alert('❌ API bağlantı hatası!\n\n' + (data.error || 'Bilinmeyen hata'));
                }
            } catch (error) {
                alert('❌ Bağlantı hatası!\n\n' + error.message);
            } finally {
                btn.innerHTML = originalText;
                btn.disabled = false;
            }
        }

        async function addKnowledge() {
            const content = document.getElementById('knowledgeContent').value.trim();
            
            if (!content) {
                alert('Lütfen içerik girin!');
                return;
            }
            
            const btn = document.getElementById('addKnowledgeBtn');
            const originalText = btn.innerHTML;
            
            btn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>Ekleniyor...';
            btn.disabled = true;
            
            try {
                const response = await fetch('/api/knowledge/add', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({
                        content: content,
                        type: 'text',
                        category: 'admin_added'
                    })
                });
                
                const data = await response.json();
                
                if (data.success) {
                    alert('✅ İçerik başarıyla eklendi!');
                    document.getElementById('knowledgeContent').value = '';
                    loadKnowledgeBase();
                } else {
                    alert('❌ İçerik eklenirken hata oluştu: ' + (data.error || 'Bilinmeyen hata'));
                }
            } catch (error) {
                alert('❌ Bağlantı hatası: ' + error.message);
            } finally {
                btn.innerHTML = originalText;
                btn.disabled = false;
            }
        }

        async function loadKnowledgeBase() {
            try {
                const response = await fetch('/api/knowledge/list');
                const data = await response.json();
                
                const container = document.getElementById('knowledgeList');
                
                if (data.success && data.knowledge && data.knowledge.length > 0) {
                    let html = '<h6>Mevcut Bilgi Bankası İçerikleri:</h6>';
                    data.knowledge.forEach((item, index) => {
                        html += `
                            <div class="alert alert-light border d-flex justify-content-between align-items-start">
                                <div>
                                    <strong>${item.name || 'İsimsiz'}</strong>
                                    <p class="mb-0 text-muted">${item.content.substring(0, 100)}...</p>
                                </div>
                                <button class="btn btn-sm btn-outline-danger" onclick="deleteKnowledge('${item.id}')">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </div>
                        `;
                    });
                    container.innerHTML = html;
                } else {
                    container.innerHTML = '<div class="alert alert-info"><i class="fas fa-info-circle me-2"></i>Henüz bilgi bankası içeriği eklenmedi.</div>';
                }
            } catch (error) {
                document.getElementById('knowledgeList').innerHTML = 
                    '<div class="alert alert-warning"><i class="fas fa-exclamation-triangle me-2"></i>Bilgi bankası yüklenirken hata oluştu.</div>';
            }
        }

        async function deleteKnowledge(knowledgeId) {
            if (!confirm('Bu içeriği silmek istediğinizden emin misiniz?')) {
                return;
            }
            
            try {
                const response = await fetch(`/api/knowledge/delete/${knowledgeId}`, {
                    method: 'DELETE'
                });
                
                const data = await response.json();
                
                if (data.success) {
                    alert('✅ İçerik başarıyla silindi!');
                    loadKnowledgeBase();
                } else {
                    alert('❌ İçerik silinirken hata oluştu: ' + (data.error || 'Bilinmeyen hata'));
                }
            } catch (error) {
                alert('❌ Bağlantı hatası: ' + error.message);
            }
        }

        // Auto-refresh stats every 30 seconds
        setInterval(loadSystemStatus, 30000);
    </script>
</body>
</html> 