<?php

try {
    $input = json_decode(file_get_contents('php://input'), true);
    
    // Initialize services
    $elevenlabsService = new ElevenlabsService($config);
    $knowledgeManager = new KnowledgeManager($config, $elevenlabsService);
    
    switch ($_SERVER['REQUEST_METHOD']) {
        case 'POST':
            // Create agent
            $knowledgeBase = $input['knowledge_base'] ?? [];
            
            $result = $elevenlabsService->createAgent($knowledgeBase);
            
            echo json_encode([
                'success' => true,
                'agent' => $result,
                'message' => 'Agent başarıyla oluşturuldu'
            ]);
            break;
            
        case 'GET':
            // Get agent info
            echo json_encode([
                'success' => true,
                'agent' => [
                    'name' => $config['assistant']['name'],
                    'company' => $config['assistant']['company'],
                    'role' => $config['assistant']['role'],
                    'voice_id' => $config['elevenlabs']['voice_id'],
                    'model' => $config['elevenlabs']['model']
                ]
            ]);
            break;
            
        default:
            http_response_code(405);
            echo json_encode(['error' => 'Method not allowed']);
            break;
    }
    
} catch (Exception $e) {
    error_log('Agent API Error: ' . $e->getMessage());
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?> 