# Gayrimenkul AI Asistanı

Elevenlabs Conversational AI teknologisi ile güçlendirilmiş, gayrimenkul sektörü için özel geliştirilmiş yapay zeka asistanı.

## 🏠 Özellikler

### Core Functionality
- **🤖 Elevenlabs AI Entegrasyonu**: Gelişmiş conversational AI ile doğal sohbet
- **🧠 Özelleştirilmiş Bilgi Tabanı**: Gayrimenkul sektörüne özel knowledge base
- **📞 Telefon & Web Desteği**: Çoklu kanal iletişim imkanı
- **👤 Kişiselleştirilmiş Etkileşim**: Müşteri adı ve telefon bilgisi ile özel konuşma
- **📋 Kapsamlı Kayıt Sistemi**: Tüm konuşmaların detaylı loglanması

### AI Asistan Özellikleri
- **İsim**: Ayşe Kaya (yapılandırılabilir)
- **Uzmanlık**: Gayrimenkul Danışmanı
- **Şirket**: Elite Gayrimenkul (yapılandırılabilir)
- **Tonlama**: Profesyonel ama samimi
- **Dil**: Türkçe
- **Açılış**: Kendini tanıtan kısa ve etkili selamlama

### Bilgi Tabanı Kategorileri
- 📊 **Genel Gayrimenkul Bilgileri**
- 💰 **Satış Süreçleri**
- 🏘️ **Kiralama Süreçleri**
- ⚖️ **Hukuki Konular**
- 🏦 **Kredi ve Mortgage**
- 📈 **Yatırım Rehberi**
- 🗺️ **Bölge Analizleri**
- 💲 **Güncel Fiyat Listeleri**

## 🚀 Kurulum

### 1. Sistem Gereksinimleri
- PHP 7.4+
- Python 3.8+
- Elevenlabs API hesabı
- Web sunucusu (Apache/Nginx) veya PHP built-in server

### 2. Python Kütüphanesi Kurulumu
```bash
# Virtual environment oluştur
python3 -m venv elevenlabs-env

# Aktifleştir
source elevenlabs-env/bin/activate  # Linux/Mac
# veya
elevenlabs-env\Scripts\activate     # Windows

# Elevenlabs kütüphanesini kur
pip install elevenlabs
```

### 3. Proje Kurulumu
```bash
# Proje dosyalarını indirin
git clone <repository-url>
cd gayrimenkul-ai

# Gerekli dizinleri oluştur
mkdir -p storage/{knowledge_base,call_logs}
chmod 755 storage

# Environment dosyasını oluştur
cp env.example .env
```

### 4. Elevenlabs Konfigürasyonu

1. [Elevenlabs Dashboard](https://elevenlabs.io/app) üzerinden:
   - API Key alın
   - Conversational AI Agent oluşturun
   - Uygun bir ses seçin

2. `.env` dosyasını düzenleyin:
```bash
ELEVENLABS_API_KEY=your_api_key_here
ELEVENLABS_AGENT_ID=your_agent_id_here
ELEVENLABS_VOICE_ID=your_voice_id_here
```

### 5. Web Sunucusu Başlatma
```bash
# PHP built-in server ile
php -S localhost:8000

# veya Apache/Nginx yapılandırması
```

## 📖 Kullanım

### Ana Dashboard
1. Web tarayıcınızda `http://localhost:8000` adresine gidin
2. AI asistan durumunu kontrol edin
3. "Varsayılan Bilgi Tabanını Yükle" butonuna tıklayın
4. API bağlantısını test edin

### AI Asistan Test Etme
1. Müşteri bilgilerini (ad, telefon) girin
2. "Aramayı Başlat" butonuna tıklayın
3. Chat arayüzü üzerinden asistanla konuşun
4. Konuşmayı sonlandırın

### Knowledge Base Yönetimi
```bash
# Yeni içerik ekleme
POST /api/knowledge/add
{
    "title": "Başlık",
    "content": "İçerik",
    "category": "genel_bilgiler"
}

# İçerik listeleme
GET /api/knowledge/list

# Arama yapma
GET /api/knowledge/search?query=tapu
```

## 🔧 API Referansı

### Agent Management
- `POST /api/agent/create` - Yeni agent oluştur
- `GET /api/agent` - Agent bilgilerini getir

### Conversation Management
- `POST /api/conversation/start` - Konuşma başlat
- `POST /api/conversation/send_message` - Mesaj gönder
- `POST /api/conversation/end` - Konuşmayı sonlandır
- `GET /api/conversation/history` - Konuşma geçmişi

### Knowledge Base Management
- `POST /api/knowledge/add` - İçerik ekle
- `POST /api/knowledge/initialize` - Varsayılan KB yükle
- `GET /api/knowledge/list` - İçerikleri listele
- `GET /api/knowledge/search` - İçerik ara
- `PUT /api/knowledge/update` - İçerik güncelle
- `DELETE /api/knowledge/delete` - İçerik sil

## 📁 Proje Yapısı

```
├── src/
│   ├── config/
│   │   └── config.php              # Ana konfigürasyon
│   ├── backend/
│   │   ├── ElevenlabsService.php   # Elevenlabs API client
│   │   └── KnowledgeManager.php    # Bilgi tabanı yöneticisi
│   ├── frontend/
│   │   ├── dashboard.php           # Ana dashboard
│   │   └── admin.php               # Yönetim paneli
│   └── api/
│       ├── agent.php               # Agent API
│       ├── conversation.php        # Konuşma API
│       └── knowledge.php           # Bilgi tabanı API
├── storage/
│   ├── knowledge_base/             # Bilgi tabanı dosyaları
│   └── call_logs/                  # Konuşma kayıtları
├── elevenlabs-env/                 # Python virtual environment
├── index.php                       # Ana uygulama dosyası
├── env.example                     # Environment örneği
└── README.md
```

## ⚙️ Konfigürasyon

### AI Asistan Kişiselleştirme
`src/config/config.php` dosyasında:

```php
'assistant' => [
    'name' => 'Ayşe Kaya',              // Asistan adı
    'role' => 'Gayrimenkul Danışmanı',  // Rolü
    'company' => 'Elite Gayrimenkul',   // Şirket
    'greeting' => [
        'formal' => 'Merhaba, ben {name}, {company} gayrimenkul danışmanıyım...',
        'friendly' => 'Selam! Ben {name}. Gayrimenkul konusunda...',
        'professional' => 'İyi günler. {name}, {company} danışmanı...'
    ]
],
```

### Voice & Model Settings
```php
'elevenlabs' => [
    'voice_id' => 'your_voice_id',
    'model' => 'eleven_multilingual_v2',
    'language' => 'turkish',
    'timeout' => 30
],
```

## 🔍 Sorun Giderme

### API Bağlantı Hatası
```
Elevenlabs API anahtarı yapılandırılmamış
```
**Çözüm**: `.env` dosyasında `ELEVENLABS_API_KEY` değerini kontrol edin.

### Bilgi Tabanı Yüklenmiyor
**Çözüm**: 
```bash
chmod 755 storage/knowledge_base
chown -R www-data:www-data storage/
```

### Agent Bulunamıyor
**Çözüm**: Elevenlabs dashboard'da agent oluşturun ve ID'yi `.env` dosyasına ekleyin.

## 📝 Geliştirme Notları

### Elevenlabs Integration
- Knowledge Base API ile otomatik senkronizasyon
- Real-time conversation handling
- Voice synthesis ve speech recognition desteği
- Custom system prompts ve personality configuration

### Security Features
- API key encryption
- Session management
- Input validation ve sanitization
- Rate limiting (gelecekte)

### Performance Optimization
- Local knowledge base caching
- Async API calls
- Response compression
- CDN ready assets

## 📞 Destek

- **Dokümantasyon**: Bu README dosyası
- **API Referansı**: `/api` endpoint'leri
- **Elevenlabs Docs**: [elevenlabs.io/docs](https://elevenlabs.io/docs)

## 📄 Lisans

Bu proje MIT lisansı altında yayınlanmıştır.

---

**Not**: Bu sistem Elevenlabs Conversational AI'ın tüm güçlü özelliklerini kullanarak gayrimenkul sektörüne özel bir çözüm sunar. Müşteri adları ve telefon bilgileri ile kişiselleştirilmiş, profesyonel ama samimi tonlu konuşmalar yapabilen AI asistanı, sektörün ihtiyaçlarına uygun bilgi tabanı ile donatılmıştır. 